#include "menu.h"
#include "init.h"
#include "vars.h"
#include "input.h"
#include "gamelogic.h"


void launch_menu(void) {
   int result_menu;
   
   do { //allez, on lance la boucle!!
      
      result_menu = play_the_menu(main_menu, IN_MENU, 0);
      //on rcupre le rsultat du menu
      
      switch (result_menu) {
         case MENU_NEW_GAME_DUEL_CLASSIC:
            new_game(DUEL);
            break;
         case MENU_NEW_GAME_DUEL_2AI :
            new_game(DUEL_2AI);
            break;
         case MENU_NEW_GAME_DUEL_2P:
            new_game(DUEL_2P);
            break;
         case MENU_NEW_GAME_2P_VS_AI :
            new_game(DUEL_2P_VS_AI);
            break;
         case MENU_OPTIONS:
				fprintf(fp, "Launching the option menu...\n");
				launch_option_menu();
            break;
         case QUIT_THE_GAME:
         case MENU_QUIT_THE_GAME:
            return;
         default:
            break;
      }
   } while (1) ;
 
   return; //Quitte le jeu
}


int new_game(int g_type){
   
   //on prpare le nouveau jeu
   init_new_game(g_type);
   //on fait ce qu'on veut
   //on lance la boucle principale
   game_state = PLAYING_THE_GAME;
   play_the_game();
   
   free_playing_vars();//on libre les objets du jeu
   //on quitte
   
   return 1;
}

//la fonction qui lance l'écran des options
void launch_option_menu(void){
	int result;
	do {
      game_time = 0;	   

		result = play_the_menu(option_menu, IN_OPTION_MENU, 0);
		
		switch(result) {
         case OPTION_MENU_DEFINE_GAME_MODE:
            fprintf(fp, "Launching the mode selector...\n");
            launch_mode_selector_menu();
            break;
			case OPTION_MENU_PL:
			   set_player_keys(&single_player);
			   save_options();
				break;
			case OPTION_MENU_PL1:
			   set_player_keys(&left_player);
			   save_options();
				break;
			case OPTION_MENU_PL2:
			   set_player_keys(&right_player);
			   save_options();
				break;
		   case QUIT_THE_GAME:
			case OPTION_MENU_RETURN:
				return;
			default:
				break;
		}
	} while(1);
	
	return;
}

void launch_mode_selector_menu(void) {
   int result_menu;
   
   do { //allez, on lance la boucle!!
      
      result_menu = play_the_menu(mode_selector_menu, IN_MODE_SELECTOR_MENU, 0);
      //on rcupre le rsultat du menu
      
      switch (result_menu) {
         case MODE_SELECTOR_MENU_REGULAR:
            game.cur_level = &l_classic;
			   save_options();            
            return;
         case MODE_SELECTOR_MENU_HARD:
            game.cur_level = &l_hard;
			   save_options();            
            return;
         case MODE_SELECTOR_MENU_UNLIMITED:
            game.cur_level = &l_unlimited;
			   save_options();            
            return;
         case QUIT_THE_GAME:
         case MODE_SELECTOR_MENU_RETURN:
            return;
         default:
            break;
      }
   } while (1) ;
 
   return;
}
